setwd("<your directory or folder path>")

#
# simulating time series data
#
series.n <- 100
time.index <- seq(from=1,to=series.n,by=1)
#
set.seed(seed=26)
#arma.sim <- 4 + arima.sim(model=list(order=c(1,0,1),ar=c(0.80),ma=c(0.80),sd=1.10,n=series.n)
ar.sim <- 4 + arima.sim(model=list(order=c(1,0,0),ar=c(0.80)),sd=1.10,n=series.n)
ma.sim <- 4 + arima.sim(model=list(order=c(0,0,1),ma=c(0.80)),sd=1.10,n=series.n)
white.noise <- rnorm(n=100,mean=4.0,sd=1.03)
ari.sim <- 4 + arima.sim(model=list(order=c(1,1,0),ar=c(0.80)),sd=1.10,n=series.n)

ar.sim95 <- ar.sim[1:95]
ma.sim95 <- ma.sim[1:95]
white.noise95 <- white.noise[1:95]
ari.sim95 <- ari.sim[1:95]
#arma.sim95 <- arma.sim[1:95]
acf(white.noise95,main="ACF for White Noise")
dev.new()
pacf(white.noise95,main="PACF for White Noise")
#dev.new()
#acf(arma.sim95,main="ACF for ARMA(1,1) Model")
#dev.new()
#pacf(arma.sim95,main="PACF for ARMA(1,1) Model")
dev.new()
acf(ar.sim95,main="ACF for AR(1) Model")
dev.new()
pacf(ar.sim95,main="PACF for AR(1) Model")
dev.new()
acf(ma.sim95,main="ACF for MA(1) Model")
dev.new()
pacf(ma.sim95,main="PACF for MA(1) Model")
dev.new()
acf(ari.sim95,main="ACF for ARI(1,1) Model")
dev.new()
pacf(ari.sim95,main="PACF for ARI(1,1) Model")
df2 <- cbind(time.index,white.noise,ar.sim,ma.sim)
write.csv(df2,"20191028 Example 15.1 Time Series Simulation.csv")
ar.model <- arima(ar.sim95,order=c(1,0,0))
ma.model <- arima(ma.sim95,order=c(0,0,1))
ar.pred <- predict(ar.model,n.ahead=5)
ma.pred <- predict(ma.model,n.ahead=5)
#test.model <- arima(arma.sim,order=c(2,0,2))
#predict(test.model,n.ahead=3)
